#ifndef OHairFromGuidesModifier_H__
#define OHairFromGuidesModifier_H__

enum
{
	// Dynamic attributes defined on enum class PlugId
	hfg_PLUGS = 1000,
	
	//////////////////////////////////////////////////////////////////////////
	// Object attributes -- DO NOT CHANGE, attribute keys on saved projects
	hfg_START = 2000,
	
	// Hair Attributes
	hfg_RootGenerationMethodAttribute,
	hfg_UniformDistributionRandomnessAttribute,
	hfg_RenderCountAttribute,
	hfg_ViewportCountAttribute,				// deprecated
	hfg_ViewportCountFractionAttribute,
	hfg_IsUsingRenderCountAttribute,
	hfg_RandomSeedAttribute,
	hfg_TopologyBasedOrientationAttribute,
	
	// use face selection
	hfg_UseSubSelectionAttribute,			// deprecated
	hfg_InterpolateStrandLengthAttribute,
	hfg_UseGuideProximityAttribute,
	hfg_GuideProximityDistanceAttribute,
	
	// use material
	hfg_MaterialIdAttribute,		// deprecated
	hfg_UseMaterialIdAttribute,		// deprecated
	
	// use face include
	hfg_UseFaceIncludeAttribute,
	hfg_UseGuideFacesAttribute,
	hfg_GuideFaceIterationCountAttribute,
	hfg_OldInterpolationTypeAttribute,
	hfg_OldInterpolationGuideCountAttribute,
	
	// Distribution map:
	hfg_DistributionChannelAttribute,
	hfg_DistributionMultiplierAttribute,
	
	// Displacement map:
	hfg_DisplacementOffsetAttribute,
	hfg_DisplacementMultiplierAttribute,
	
	// Cached strands
	hfg_RememberRootPositionsAttribute,
	hfg_CachedRootFacesAttribute_Array,
	hfg_CachedRootCoordinatesAttribute_Array,
	hfg_CachedGuideIndicesAttribute_Array,
	hfg_CachedGuideDistancesAttribute_Array,
	hfg_CachedStrandIdsAttribute_Array,
	
	hfg_GuideWeightsChannelAttribute = 2041,
	hfg_InterpolateGuidesInUvSpaceAttribute,
	hfg_CachedGuideOffsetsAttribute_Array,
	
	// new interpolation type #3593
	hfg_InterpolationTypeAttribute,
	hfg_InterpolationGuideCountAttribute,
	hfg_GuideAreaTypeAttribute,
	hfg_GuideAreaCircleThroughNearestAttribute,
	hfg_GuideAreaCircleRadiusAttribute,
	hfg_GuideInterpolation_Group,
	
	// New interpolation options #3992
	hfg_GuideAreaBarycentricTriangulationTypeAttribute,
	hfg_GenerateRotationsAttribute,
	hfg_GeneratePerStrandDataAttribute,
	hfg_GeneratePerVertexDataAttribute,
	hfg_HairData_Group,
	
	// Mulktiplier maps UVW tag selection #4211
	hfg_DistributionMultiplierChannelAttribute,
	hfg_DisplacementMultiplierChannelAttribute,
	
	// #4233 Selection tag improvements
	hfg_FaceIncludeSelectionTagAttribute,

	// Parting settings
	hfg_Parting_Group = 2100,
	hfg_PartingCount,
	hfg_SelectedPartingIndex,
	hfg_AutoPartAttribute,
	hfg_AngleThresholdAttribute,
	hfg_DistanceThresholdAttribute,
	hfg_PartingGroupsMapAttribute,
	hfg_PartingsChannelAttribute,

	// Per-parting attributes
	hfg_PartingFaceIndexAttribute = 2150,
	hfg_PartingFaceIndexAttribute_Array,
	hfg_PartingCoordinatesAttribute,
	hfg_PartingCoordinatesAttribute_Array,
	hfg_PartingDirectionAttribute,
	hfg_PartingDirectionAttribute_Array,


	
	//////////////////////////////////////////////////////////////////////////
	
	// Buttons
	
	hfg_Button_RootGenerationMethodAttribute_UNIFORM = 3000,
	hfg_Button_RootGenerationMethodAttribute_RANDOM_UV,
	hfg_Button_RootGenerationMethodAttribute_RANDOM_AREA,
	hfg_Button_RootGenerationMethodAttribute_RANDOM_FACE,
	hfg_Button_RootGenerationMethodAttribute_VERTEX,
	hfg_Button_RootGenerationMethodAttribute_GUIDE_AS_HAIR,
	hfg_Button_RootGenerationMethodAttribute_FACE_CENTER,
	hfg_Button_RootGenerationMethodAttribute_EVEN,
	
	hfg_Button_GuideAreaTypeAttribute_NClosestGuides,
	hfg_Button_GuideAreaTypeAttribute_Barycentric,
	hfg_Button_GuideAreaTypeAttribute_Circle,

	hfg_Button_InterpolationTypeAttribute_POLAR,
	hfg_Button_InterpolationTypeAttribute_AFFINE,
	hfg_Button_InterpolationTypeAttribute_BARYCENTRIC,	//deprecated
	hfg_Button_InterpolationTypeAttribute_SEGMENT,
	
	hfg_Button_InterpolationGuideCountAttribute_ONE,
	hfg_Button_InterpolationGuideCountAttribute_TWO,
	hfg_Button_InterpolationGuideCountAttribute_THREE,
	
	hfg_Button_Parting_Add,
	hfg_Button_Parting_Edit,
	hfg_Button_Parting_Delete,

	// Labels
	
	hfg_RememberRootPositionsAttribute_Label = 3100,
	
	hfg_END
};

enum
{
	// Same order as RootGenerator::RootGenerationMethod
	hfg_RootGenerationMethodAttribute_UNIFORM,
	hfg_RootGenerationMethodAttribute_RANDOM_UV,
	hfg_RootGenerationMethodAttribute_RANDOM_AREA,
	hfg_RootGenerationMethodAttribute_RANDOM_FACE,
	hfg_RootGenerationMethodAttribute_VERTEX,
	hfg_RootGenerationMethodAttribute_GUIDE_AS_HAIR,
	hfg_RootGenerationMethodAttribute_FACE_CENTER,
	hfg_RootGenerationMethodAttribute_EVEN,
};

enum
{
	// Same order as HairFromGuidesGenerator::GuideAreaCalculationMethod
	hfg_GuideAreaTypeAttribute_NClosestGuides,
	hfg_GuideAreaTypeAttribute_Barycentric,
	hfg_GuideAreaTypeAttribute_Circle,
	hfg_GuideAreaTypeAttribute_Count
};

enum
{
	// Same order as HairFromGuidesGenerator::OldInterpolationMethod
	hfg_OldInterpolationTypeAttribute_POLAR,
	hfg_OldInterpolationTypeAttribute_AFFINE,
	hfg_OldInterpolationTypeAttribute_BARYCENTRIC,
	hfg_OldInterpolationTypeAttribute_SEGMENT,
	hfg_OldInterpolationTypeAttribute_COUNT
};

enum
{
	// Same order as HairFromGuidesGenerator::InterpolationMethod
	hfg_InterpolationTypeAttribute_POLAR,
	hfg_InterpolationTypeAttribute_AFFINE,
	hfg_InterpolationTypeAttribute_SEGMENT,
	hfg_InterpolationTypeAttribute_COUNT
};

enum
{
	hfg_InterpolationGuideCountAttribute_ONE = 1,
	hfg_InterpolationGuideCountAttribute_TWO = 2,
	hfg_InterpolationGuideCountAttribute_THREE = 3,
};

enum
{
	// Matches HairFromGuidesGenerator::GuideAreaBarycentricTriangulationType
	hfg_TriangulationType_DistributionMesh,
	hfg_TriangulationType_NearestNeighbourTriangulation,
	hfg_TriangulationType_ManualTriangulation,
	//
	hfg_TriangulationType_Count,
};

#endif
